clear all

* Set Folder to output one

cd ..\Outputs

* Call database of merged unemployment and real GDP growth

use vin_all, clear

* Define the matrix of long-run restrictions

matrix sr = (.,0\.,.)

local sizeofwindow=120

quiet forvalues yy=107(2)117 {

	local qq=2
	if `yy'==117 local qq=1
	
	if `yy'<100 local str0="`yy'Q`qq'"
	if `yy'>=100 & `yy'<110 {
		local yy1=`yy'-100
		local str0="0`yy1'Q`qq'"
	}
	if `yy'>=110 {
		local yy1=`yy'-100
		local str0="`yy1'Q`qq'"
	}

	* Define growth of output and consumption as the last available vintage
	* as well as the ratio between consumption and output and its lag
	
	tsset t

	capture drop logY logC dlogY dlogC CYratio LCYratio
	gen logY      = log(ROUTPUT`str0')
	* Choose if we use total cons or just cons of non-durables and services
	gen logC      = log(RCON`str0')
	*gen logC      = log(RCONNDS`str0')
	gen dlogY     = d.logY
	gen dlogC     = d.logC
	gen CYratio   = logC-logY
	gen LCYratio  = l.CYratio
	
	summ t if dlogY!=.
	local lastt=r(max)

	* Run the Cochrane structural VAR with exogenous variables
	
	varsoc dlogC dlogY if t>`=`lastt'-`sizeofwindow'', maxlag(10)

	noisily di "`yy'Q`qq'"
	svar dlogC dlogY if t>`=`lastt'-`sizeofwindow'', lags(1/2) aeq(sr) exog(LCYratio) var
	
	matrix Aest   = e(A)
	matrix Best   = e(B)
	matrix transf = inv(Best)*Aest
	matrix cochR  = inv(transf)
	matrix Vco = e(b_var)
	
	/*
	
	* Just for illustrative purposes you can take a look at the matrices
	* I don't really use them explicitly though
	
	matrix ARresps = (Vco[1,1],Vco[1,2],Vco[1,3],Vco[1,4 ],Vco[1,5]  \ ///
	                  Vco[1,7],Vco[1,8],Vco[1,9],Vco[1,10],Vco[1,11] \ ///
					  1       ,0       ,0       ,0        ,0         \ ///
					  0       ,1       ,0       ,0        ,0         \ ///
					  Vco[1,1]-Vco[1,7],Vco[1,2]-Vco[1,8],Vco[1,3]-Vco[1,9],Vco[1,4]-Vco[1,10],1+Vco[1,5]-Vco[1,11])
	
	matrix ARerres = (cochR[1,1],cochR[1,2] \ ///
	                  cochR[2,1],cochR[2,2] \ ///
					  0         ,0          \ ///
					  0         ,0          \ ///
					  cochR[1,1]-cochR[2,1],cochR[1,2]-cochR[2,2])
					  
	*/
	
	capture drop resid*
	predict residP, resid equation(#1)
	predict residT, resid equation(#2)

	* Obtain structural shocks
	* The matrix transf turns residuals into structural shocks with variance
	* covariance matrix of identity. The inverse of tranf, which would
	* be just the inverse of A, (since B is an identity matrix), turns
	* structural shocks into residuals

	capture drop temp*
	gen temp_per=transf[1,1]*residP+transf[1,2]*residT
	gen temp_tra=transf[2,1]*residP+transf[2,2]*residT
	replace temp_per=0 if temp_per==. & t>`lastt'
	replace temp_tra=0 if temp_tra==. & t>`lastt'
	
	capture drop predlogC predlogY preCYratio
	gen predlogC=0
	gen predlogY=0
	gen preCYratio=0
	forvalues ploop = `=`lastt'-`sizeofwindow''(1)280 {
		replace predlogC=Vco[1,1]*predlogC[`=`ploop'-1']+Vco[1,2]*predlogY[`=`ploop'-1']+Vco[1,3]*predlogC[`=`ploop'-2']+Vco[1,4 ]*predlogY[`=`ploop'-2']+Vco[1,5 ]*preCYratio[`=`ploop'-1']+cochR[1,1]*temp_per if t==`ploop'
		replace predlogY=Vco[1,7]*predlogC[`=`ploop'-1']+Vco[1,8]*predlogY[`=`ploop'-1']+Vco[1,9]*predlogC[`=`ploop'-2']+Vco[1,10]*predlogY[`=`ploop'-2']+Vco[1,11]*preCYratio[`=`ploop'-1']+cochR[2,1]*temp_per if t==`ploop'
		replace preCYratio=(Vco[1,1]-Vco[1,7])*predlogC[`=`ploop'-1']+(Vco[1,2]-Vco[1,8])*predlogY[`=`ploop'-1']+(Vco[1,3]-Vco[1,9])*predlogC[`=`ploop'-2']+(Vco[1,4]-Vco[1,10])*predlogY[`=`ploop'-2']+(Vco[1,5]-Vco[1,11])*preCYratio[`=`ploop'-1']+(cochR[1,1]-cochR[2,1])*temp_per if t==`ploop'
	}
	
	gen dlogY_CH_per`yy1'=predlogY
	replace dlogY_CH_per`yy1'=. if t>280
	
	sum dlogY
	replace dlogY_CH_per`yy1'=dlogY_CH_per`yy1'+r(mean)
	
}

gen   time      = year+(quarter-1)/4
local base      = 2007
summ t if time==`base'
local obsofbase = r(mean)

local baseindex = 2000
local counter=1
foreach var of varlist dlogY_CH_per* GROUTPUT17Q1 {
	gen sap`counter'=.
	replace sap`counter'=0 if time==`baseindex'
	if `counter'<7  replace sap`counter'=sap`counter'[_n-1]+`var' if sap`counter'==. & time>`baseindex'
	if `counter'==7 replace sap`counter'=sap`counter'[_n-1]+`var'/400 if sap`counter'==. & time>`baseindex'
	local ++counter
}

ds sap*

foreach var of varlist `r(varlist)' {
	gen `var'base=`var'[`obsofbase']
	replace `var'=`var'-`var'base
	drop `var'base
}

local from      = 2004
local to        = 2017

twoway ///
(line sap1 time if year>=`from' & year<=`to', lcolor(red)) ///
(line sap2 time if year>=`from' & year<=`to', lcolor(green) lpattern(dash_dot)) ///
(line sap3 time if year>=`from' & year<=`to', lcolor(blue) lpattern(dash)) ///
(line sap4 time if year>=`from' & year<=`to', lcolor(black) lpattern(shortdash)) ///
(line sap5 time if year>=`from' & year<=`to', lcolor(teal) lpattern(shortdash_dot)) ///
(line sap6 time if year>=`from' & year<=`to', lcolor(purple) lpattern(longdash)) ///
(line sap7 time if year>=`from' & year<=`to', lcolor(black) lwidth(thick)) ///	
, ///
xlabel(`from'(2)`to') xtitle("Year") ///
ylabel(-0.1(0.05)0.3) ytitle("log deviation from 2007Q1") ///
legend(	label(1 "CH 2007") label(2 "CH 2009") label(3 "CH 2011") ///
		label(4 "CH 2013") label(5 "CH 2015") label(6 "CH 2017") ///
		label(7 "Actual") ring(0) position(11) rows(4)) ///
graphregion(color(white)) bgcolor(white) name(sap)

rename sap1 fig14COC1
rename sap2 fig14COC2
rename sap3 fig14COC3
rename sap4 fig14COC4
rename sap5 fig14COC5
rename sap6 fig14COC6

keep t year quarter time fig14COC*

save fig14COC, replace
